/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileFilter;
import com.ibm.hsc.filesvr.FsPacket;

public class FsFileListPacket
extends FsPacket {
    public static final int FILE_LIST_FORMAT_1 = 1;
    public static final int FILE_LIST_FORMAT_2 = 2;
    public static final int FILE_LIST_FORMAT_3 = 3;
    protected static final int FILE_FILTER_NAME = 1;
    protected static final int FILE_FILTER_SIZE_MAXIMUM = 2;
    protected static final int FILE_FILTER_SIZE_MINIMUM = 3;
    protected static final int FILE_FILTER_DATE_MAXIMUM = 4;
    protected static final int FILE_FILTER_DATE_MINIMUM = 5;
    protected FsFileFilter m_filter = new FsFileFilter();
    protected int m_fileListFormat = 1;

    protected FsFileListPacket(FsConnection fsConnection) {
        super(fsConnection, 4);
    }

    protected FsFileListPacket(FsConnection fsConnection, int n) {
        super(fsConnection, 4);
        this.setFileType(n);
    }

    protected FsFileListPacket(FsConnection fsConnection, int n, int n2) {
        super(fsConnection, 4);
        this.setFileType(n);
        this.setFileListFormat(n2);
    }

    protected FsFileListPacket(FsPacket fsPacket) {
        super(fsPacket, 5);
    }

    protected FsFileListPacket(FsPacket fsPacket, int n) {
        super(fsPacket, 4);
        this.setFileType(n);
    }

    protected FsFileListPacket(FsPacket fsPacket, int n, int n2) {
        super(fsPacket, 4);
        this.setFileType(n);
        this.setFileListFormat(n2);
    }

    protected FsFileListPacket(FsFileListPacket fsFileListPacket) {
        super(fsFileListPacket);
        this.m_filter = fsFileListPacket.m_filter;
        this.setFileListFormat(fsFileListPacket.getFileListFormat());
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (this.getOpCode() != 4) {
            throw new FsException(19, this.getOpCode());
        }
        fsByteStream.writeInt(this.m_filter.getType());
        fsByteStream.writeInt(this.m_fileListFormat);
    }

    public int getFileType() {
        return this.m_filter.getType();
    }

    public int getFileListFormat() {
        return this.m_fileListFormat;
    }

    public boolean isValid() {
        return super.isValid() && this.getOpCode() == 4;
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (this.getOpCode() != 4) {
            throw new FsException(19, this.getOpCode());
        }
        this.m_filter.setType(fsByteStream.readInt());
        if (this.m_filter.getType() != 1) {
            throw new FsException(23, this.m_filter.getType());
        }
        this.m_fileListFormat = fsByteStream.readInt();
        if (this.m_fileListFormat != 1 && this.m_fileListFormat != 2 && this.m_fileListFormat != 3) {
            throw new FsException(24, this.m_fileListFormat);
        }
    }

    public void setFileType(int n) {
        this.m_filter.setType(n);
    }

    public void setFileListFormat(int n) {
        this.m_fileListFormat = n;
    }
}

